#define RECORDERNAME "Next\\Sun AU Recorder"

#include "recorder.h"
#include "resource.h"
  
class rec : public COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack() { return false; };
	virtual bool __cdecl IsTagged() { return true; };
	virtual bool __cdecl IsStreamed() { return false; };
	virtual bool __cdecl IsRequiresWaveout() { return false; };
	virtual bool __cdecl IsLossyCompression() { return false; };

	virtual bool __cdecl IsSampleRateChangeable() { return false; };
	virtual bool __cdecl SampleRateChanged(int samplerate) { return false; };
	virtual bool __cdecl IsBitRateChangeable() { return false; };
	virtual bool __cdecl BitRateChanged(int bitrate) { return false; };

	virtual bool __cdecl SupportsSampleRate(int samplerate) { return true; };
	virtual bool __cdecl SupportsBitRate(int bitrate) { return true; };

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name) { return false; };
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata);

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples) { return false; };

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain) { };
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain) { };

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id) { return "No Extra Info"; };
	virtual char * __cdecl RecordersWebSiteURL() { return "http://www.buzzscene.ca/"; };

	virtual int __cdecl RecorderVersion() { return 100; };

	virtual void GetRecorderExtensionsClass(int param, void **exmodule) { };
public:
	char myfilename[255];
	FILE * myfilehandle;
	char songtitle[100];
	char songartist[100];
	int writtensofar;
	int bitdepth;
	int samplerate;
};

bool rec::Init(){
	sprintf(myfilename, "");
	myfilehandle = NULL;
	writtensofar = 0;
	bitdepth = 0;
	sprintf(songtitle, "");
	sprintf(songartist, "");
	samplerate = 44100;
	return true;
}
bool rec::SaveAs(HWND parentwindow){
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"untitled.au");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "Next\\Sun sound format (*.au)\0*.au\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Song Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".au";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}

static union {
	long  longvalue;
	char  longvaluebytes[4];
};

static union {
	short thepsamp;
	char  thepsampbytes[2];
};

bool rec::SongTagData(int tag_index, char *tagdata) {
	switch (tag_index) {
	case 0: sprintf(songtitle, tagdata); return true; 
	case 1: sprintf(songartist, tagdata); return true;
	case 2: return false;
	default:
		return false;
	}
}

bool rec::Start (char * filename, int samplespersec) {
	char addinfo[204];
	short data1 = 0x0000;
	char data1a = 0x00;
	char data1b = 0x00; // custom
	long data2 = 0xFFFFFFFF;
	long data3 = 0x03000000;
	//short data4 = 0x0000;
	long data5 = 0x02000000;
	long datablk=0x00000000;

	char longvaluebyte;
	samplerate = samplespersec;
	unsigned int invsamplerate = 44100;

	longvalue = samplerate;
	longvaluebyte = longvaluebytes[0];
	longvaluebytes[0] = longvaluebytes[3];
	longvaluebytes[3] = longvaluebyte;
	longvaluebyte = longvaluebytes[1];
	longvaluebytes[1] = longvaluebytes[2];
	longvaluebytes[2] = longvaluebyte;
	invsamplerate = longvalue;


	myfilehandle = fopen(filename, "wb");
	writtensofar = 0;

	if (strlen(songartist) == 0) {
		if (strlen(songtitle) == 0) {
			sprintf(addinfo, "");
		} else {
			sprintf(addinfo, "%s", songtitle);
		}
	} else {
		if (strlen(songtitle) == 0) {
			sprintf(addinfo, "%s", songartist);
		} else {
			sprintf(addinfo, "%s - %s", songartist, songtitle);
		}
	}
	
	fwrite(".snd", 1, 4,myfilehandle);
	
	data1b = 24 + strlen(addinfo)+1;
	fwrite(&data1, sizeof(short), 1, myfilehandle);
	fwrite(&data1a, sizeof(char), 1, myfilehandle);
	fwrite(&data1b, sizeof(char), 1, myfilehandle);

	fwrite(&data2, sizeof(long), 1,myfilehandle);
	fwrite(&data3, sizeof(long), 1,myfilehandle);
	fwrite(&invsamplerate, sizeof(long), 1,myfilehandle);
//	fwrite(&data4, sizeof(short), 1,myfilehandle);
	fwrite(&data5, sizeof(long), 1,myfilehandle);

	fwrite(addinfo, sizeof(char), strlen(addinfo)+1, myfilehandle);

	return true;
}
bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}

}

bool rec::WorkOutput (float *psamples, int numsamples) {
	short psampsm[1024];
	char bufpsampbyte;
	for (int i = 0; i < (numsamples * 2); i++) {
		if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
		if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
		psampsm[i] = (short)psamples[i];
		thepsamp = psampsm[i];
		bufpsampbyte = thepsampbytes[0];
		thepsampbytes[0] = thepsampbytes[1];
		thepsampbytes[1] = bufpsampbyte;
		psampsm[i] = thepsamp;
	}
	writtensofar += numsamples;
	fwrite(psampsm, sizeof(short), numsamples * 2,myfilehandle);
	return true;
}

bool rec::Finish() {
	fflush(myfilehandle);
	fclose(myfilehandle);
	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	if (bitdepth == 1) {
		sprintf(megs, "%.2fM", ((float)writtensofar * 4.0f / 1024.0f / 1024.0f));
	} else {
		sprintf(megs, "%.2fM", ((float)writtensofar * 2.0f * (float)sizeof(float) / 1024.0f / 1024.0f));
	}
	return megs;
}

rec *prec;

BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
//		if (prec->bitdepth == 1) {
//			CheckDlgButton(hDlg,IDC_RADIO16,1);
//		} else {
//			CheckDlgButton(hDlg,IDC_RADIO32,1);
//		}
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			
//			if (IsDlgButtonChecked(hDlg, IDC_RADIO32) == 1) { prec->bitdepth = 0; }
//			if (IsDlgButtonChecked(hDlg, IDC_RADIO16) == 1) { prec->bitdepth = 1; }

			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

void rec::ConfigDlg (HWND parentwindow) {
	prec = this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

void rec::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {

}

void rec::DispatchCommandEx(char * str_command, char * str_value) { 
	if (strcmp(str_command, "about") == 0) {
		MessageBox(*(HWND*)str_value, "Next\\Sun Audio Recorder 1.2\nCoded by Edward L. Blake aka Cyanphase\nCopyright 2002 Edward L. Blake", "About Next\\Sun Audio Recorder", MB_OK | MB_ICONINFORMATION);
	}
}

EXPORTTHING
